// Created by inigo quilez - iq/2015
// License Creative Commons Attribution-NonCommercial-ShareAlike 3.0 Unported License.

//#define USE_GRADIENTS

float2 R:TARGETSIZE;

Texture2D tex0 <string uiname="Texture";>;
SamplerState s0:IMMUTABLE
{
    Filter = MIN_MAG_MIP_LINEAR;
    AddressU = wrap;
    AddressV = wrap;
};

cbuffer cbPerDraw:register( b0 )
{
float4x4 tVP:VIEWPROJECTION;
float4x4 tW:WORLD;
float time;
};

float4 texCube( Texture2D tex0, in float3 p, in float3 n, in float k )
{
	float4 x = tex0.Sample( s0, p.yz );
	float4 y = tex0.Sample( s0, p.zx );
	float4 z = tex0.Sample( s0, p.xy );
    float3 w = pow( abs(n), float(k) );
	return (x*w.x + y*w.y + z*w.z) / (w.x+w.y+w.z);
}

float4 map2( float3 p )
{
    p.x += 0.5*sin( 3.0*p.y + time );
    p.y += 0.5*sin( 3.0*p.z + time );
    p.z += 0.5*sin( 3.0*p.x + time );
    p.x += 0.5*sin( 3.0*p.y + time );
    p.y += 0.5*sin( 3.0*p.z + time );
    p.z += 0.5*sin( 3.0*p.x + time );
    p.x += 0.5*sin( 3.0*p.y + time );
    p.y += 0.5*sin( 3.0*p.z + time );
    p.z += 0.5*sin( 3.0*p.x + time );
    p.x += 0.5*sin( 3.0*p.y + time );
    p.y += 0.5*sin( 3.0*p.z + time );
    p.z += 0.5*sin( 3.0*p.x + time );

    float d1 = length(p) - 1.0*smoothstep(0.0,2.0,time);;
    d1 *= 0.02;	

    return float4( d1, p );
}

float4 map( float3 p )
{
    float4 res = map2(p);
    
    float d2 = p.y + 1.0;
    if( d2<res.x ) res = float4( d2, 0.0, 0.0, 0.0 );

	return res;
}

float4 intersect( in float3 ro, in float3 rd, in float maxd )
{
    float3 res = float(-1.0);
	float precis = 0.00005;
    float t = 1.0;
    for( int i=0; i<512; i++ )
    {
	    float4 tmp = map( ro+rd*t );
        res = tmp.yzw;
        float h = tmp.x;
        if( h<precis||t>maxd ) break;
        t += h;
    }

    return float4( t, res );
}

float3 calcNormal( in float3 pos )
{
#ifdef USE_GRADIENTS    
    return normalize( cross(ddx(pos),ddy(pos)) );
#else    
    float2 e = float2(1.0,-1.0)*0.001;
    return normalize( e.xyy*map( pos + e.xyy ).x + 
					  e.yyx*map( pos + e.yyx ).x + 
					  e.yxy*map( pos + e.yxy ).x + 
					  e.xxx*map( pos + e.xxx ).x );
#endif    
}

float softshadow( in float3 ro, in float3 rd, float mint, float k )
{
    float res = 1.0;
    float t = mint;
	float h = 1.0;
    for( int i=0; i<128; i++ )
    {
        h = map(ro + rd*t).x;
        res = min( res, k*h/t );
        if( res<0.0001 ) break;
        t += clamp( h, 0.01, 0.05 );
    }
    return clamp(res,0.0,1.0);
}

float calcOcc( in float3 pos, in float3 nor )
{
    const float h = 0.2;
	float ao = 0.0;
    for( int i=0; i<8; i++ )
    {
        float3 dir = sin( float(i)*float3(1.0,7.13,13.71)+float3(0.0,2.0,4.0) );
        //dir = normalize(nor + dir);
        dir *= sign(dot(dir,nor));
        float d = map2( pos + h*dir ).x;
        ao += max(0.0,h-d*2.0);
    }
    return clamp( 4.0 - 2.5*ao, 0.0, 1.0 )*(0.5+0.5*nor.y);
}

float3 lig = normalize(float3(1.0,0.7,0.9));


struct VS_IN
{
	float4 PosO:POSITION;
	float4 TexCd:TEXCOORD0;

};

struct vs2ps
{
    float4 PosWVP:SV_POSITION;
    float4 TexCd:TEXCOORD0;
};

vs2ps VS(VS_IN input)
{
    vs2ps output;
    output.PosWVP = mul(input.PosO,tW);
    output.TexCd = input.TexCd;
    return output;
}

float4 PS(vs2ps In) : SV_Target
{
    float2 q = In.TexCd.xy;
	q.y=1-In.TexCd.y;
    float2 p = -1.0 + 2.0 * q;
    p.x *= R.x/R.y;
    float2 m = float(0.5);

	
    //-----------------------------------------------------
    // camera
    //-----------------------------------------------------
	
	float an = 0.3*time + 7.5 - 5.0*m.x;

	float3 ro = float3(4.5*sin(an),0.5,4.5*cos(an));
    float3 ta = float3(0.0,0.5,0.0);

    // camera matrix
    float3 ww = normalize( ta - ro );
    float3 uu = normalize( cross(ww,float3(0.0,1.0,0.0) ) );
    float3 vv = normalize( cross(uu,ww));

	// create view ray
	float3 rd = normalize( p.x*uu + p.y*vv + 2.0*ww );

    //-----------------------------------------------------
	// render
    //-----------------------------------------------------

	float3 col = float(0.0);
	// raymarch
    const float maxd = 9.0;
    float4  inn = intersect(ro,rd,maxd);
    float t = inn.x;
    if( t<maxd )
    {
        float3 tra = inn.yzw;

        // geometry
        float3 pos = ro + t*rd;
        float3 nor = calcNormal(pos);
		float3 ref = reflect( rd, nor );

        // material
        col = float3(0.3,0.3,0.3);
        if( pos.y>-0.99) col += 0.2*tra;
        float3 pat = texCube( tex0, 0.5*pos, nor, 4.0 ).xyz;
        col *= pat;
        col *= 0.5;
        
		// lighting
		float occ = calcOcc( pos, nor );

        float amb = 0.5 + 0.5*nor.y;
		float dif = max(dot(nor,lig),0.0);
		float bou = max(0.0,-nor.y);
        float bac = max(0.2 + 0.8*dot(nor,-lig),0.0);
		float sha = 0.0; if( dif>0.01 ) sha=softshadow( pos+0.01*nor, lig, 0.0005, 128.0 );
        float fre = pow( clamp( 1.0 + dot(nor,rd), 0.0, 1.0 ), 3.0 );
        float spe = 15.0*pat.x*max( 0.0, pow( clamp( dot(lig,reflect(rd,nor)), 0.0, 1.0), 16.0 ) )*dif*sha*(0.04+0.96*fre);
		
		// lights
		float3 lin = float(0.0);

        lin += 3.5*dif*float3(6.00,4.00,3.00)*pow(float(sha),float3(1.0,1.2,1.5));
		lin += 1.0*amb*float3(0.30,0.30,0.30)*occ;
		lin += 1.0*bac*float3(0.80,0.50,0.20)*occ;
		lin += 1.0*bou*float3(1.00,0.30,0.20)*occ;
        lin += 4.0*fre*float3(1.00,0.80,0.70)*(0.3+0.7*dif*sha)*occ;
        lin += spe*2.0;

        // surface-light interacion
		col = col*lin + spe;

        col *= min(200.0*exp(-1.5*t),1.0);
        col *= 1.0-smoothstep( 1.0,6.0,length(pos.xz) );
	}

    // gamma
	col = pow( clamp(col,0.0,1.0), float(0.4545) );

    // grading
    col = pow( col, float3(0.6,1.0,1.0) );
    // vignetting
    col *= pow( abs(16.0*q.x*q.y*(1.0-q.x)*(1.0-q.y)), 0.1 );
	   
    return float4( col, 1.0 );

}


technique10 SculptureII
{
	pass P0
	{
		SetVertexShader(CompileShader(vs_4_0,VS()));
		SetPixelShader(CompileShader(ps_4_0,PS()));
	
	}
}



